using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace jp.co.knowlbo.TimeView.Appearance
{
	/// <summary>
	/// Form1 ̊Tv̐łB
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label lblCaption;
		private System.Windows.Forms.Button cmdCoolNo1;
		private System.Windows.Forms.Button cmdCoolNo2;
		private System.Windows.Forms.Button cmdSecondForm;
		private System.Windows.Forms.Button cmdPreview;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;
		private AxKnTViewLib.AxKnTView axKnTView2;
		

		private struct Schedule
		{
			public int TaskIndex;
			public DateTime Start;
			public DateTime Finish;
			public float Progress;
		}
		private Schedule[] Schedules = new Schedule[7];
		
		private void LoadSchedule()
		{
			Schedules[0].TaskIndex = 1;
			Schedules[0].Start = Convert.ToDateTime("1999/8/5 9:00");
			Schedules[0].Finish = Convert.ToDateTime("1999/8/5 11:00");
			Schedules[0].Progress = (float)0.2;

			Schedules[1].TaskIndex = 2;
			Schedules[1].Start = Convert.ToDateTime("1999/8/5 13:00");
			Schedules[1].Finish = Convert.ToDateTime("1999/8/5 14:30");
			Schedules[1].Progress = (float)0.6;

			Schedules[2].TaskIndex = 3;
			Schedules[2].Start = Convert.ToDateTime("1999/8/5 16:00");
			Schedules[2].Finish = Convert.ToDateTime("1999/8/5 17:00");
			Schedules[2].Progress = (float)0.7;

			Schedules[3].TaskIndex = 4;
			Schedules[3].Start = Convert.ToDateTime("1999/8/5 9:00");
			Schedules[3].Finish = Convert.ToDateTime("1999/8/5 11:00");
			Schedules[3].Progress = 1;

			Schedules[4].TaskIndex = 5;
			Schedules[4].Start = Convert.ToDateTime("1999/8/5 10:00");
			Schedules[4].Finish = Convert.ToDateTime("1999/8/5 17:00");
			Schedules[4].Progress = (float)0.5;

			Schedules[5].TaskIndex = 6;
			Schedules[5].Start = Convert.ToDateTime("1999/8/5 15:00");
			Schedules[5].Finish = Convert.ToDateTime("1999/8/5 15:30");
			Schedules[5].Progress = (float)0.5;

			Schedules[6].TaskIndex = 7;
			Schedules[6].Start = Convert.ToDateTime("1999/8/5 18:00");
			Schedules[6].Finish = Convert.ToDateTime("1999/8/5 20:00");
			Schedules[6].Progress = (float)0.5;
		}

		public MainForm()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MainForm));
			this.lblCaption = new System.Windows.Forms.Label();
			this.cmdCoolNo1 = new System.Windows.Forms.Button();
			this.cmdCoolNo2 = new System.Windows.Forms.Button();
			this.cmdSecondForm = new System.Windows.Forms.Button();
			this.cmdPreview = new System.Windows.Forms.Button();
			this.axKnTView2 = new AxKnTViewLib.AxKnTView();
			((System.ComponentModel.ISupportInitialize)(this.axKnTView2)).BeginInit();
			this.SuspendLayout();
			// 
			// lblCaption
			// 
			this.lblCaption.Location = new System.Drawing.Point(16, 8);
			this.lblCaption.Name = "lblCaption";
			this.lblCaption.Size = new System.Drawing.Size(560, 40);
			this.lblCaption.TabIndex = 0;
			this.lblCaption.Text = "ꂼ̋ƖɓKʂ̍쐬\ɂ邽߁A̓fBxbp̃A[eBXeBbNȃZX߂ɁAAsAXɊւ鑮Lxɔ܂BOf[" +
				"VȂǂ܂ނPXނ̃tB p^[Tނ̃C p^[AeZAes[XAes̃s[X\̈Ae񌩏ôꂼɂĐݒ肷邱Ƃ\" +
				"B";
			// 
			// cmdCoolNo1
			// 
			this.cmdCoolNo1.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.cmdCoolNo1.Location = new System.Drawing.Point(504, 64);
			this.cmdCoolNo1.Name = "cmdCoolNo1";
			this.cmdCoolNo1.Size = new System.Drawing.Size(80, 32);
			this.cmdCoolNo1.TabIndex = 2;
			this.cmdCoolNo1.Text = "Cool No.1";
			this.cmdCoolNo1.Click += new System.EventHandler(this.cmdCoolNo1_Click);
			// 
			// cmdCoolNo2
			// 
			this.cmdCoolNo2.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.cmdCoolNo2.Location = new System.Drawing.Point(504, 104);
			this.cmdCoolNo2.Name = "cmdCoolNo2";
			this.cmdCoolNo2.Size = new System.Drawing.Size(80, 32);
			this.cmdCoolNo2.TabIndex = 3;
			this.cmdCoolNo2.Text = "Cool No.2";
			this.cmdCoolNo2.Click += new System.EventHandler(this.cmdCoolNo2_Click);
			// 
			// cmdSecondForm
			// 
			this.cmdSecondForm.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.cmdSecondForm.Location = new System.Drawing.Point(504, 144);
			this.cmdSecondForm.Name = "cmdSecondForm";
			this.cmdSecondForm.Size = new System.Drawing.Size(80, 32);
			this.cmdSecondForm.TabIndex = 4;
			this.cmdSecondForm.Text = "Second Form";
			this.cmdSecondForm.Click += new System.EventHandler(this.cmdSecondForm_Click);
			// 
			// cmdPreview
			// 
			this.cmdPreview.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.cmdPreview.Location = new System.Drawing.Point(504, 200);
			this.cmdPreview.Name = "cmdPreview";
			this.cmdPreview.Size = new System.Drawing.Size(80, 32);
			this.cmdPreview.TabIndex = 5;
			this.cmdPreview.Text = "Print Preview";
			this.cmdPreview.Click += new System.EventHandler(this.cmdPreview_Click);
			// 
			// axKnTView2
			// 
			this.axKnTView2.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.axKnTView2.Location = new System.Drawing.Point(8, 64);
			this.axKnTView2.Name = "axKnTView2";
			this.axKnTView2.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("axKnTView2.OcxState")));
			this.axKnTView2.Size = new System.Drawing.Size(488, 222);
			this.axKnTView2.TabIndex = 6;
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(592, 294);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.axKnTView2,
																		  this.cmdPreview,
																		  this.cmdSecondForm,
																		  this.cmdCoolNo2,
																		  this.cmdCoolNo1,
																		  this.lblCaption});
			this.Name = "MainForm";
			this.Text = "^Cr[@|@\Љ|@LxȃAsAX";
			this.Load += new System.EventHandler(this.MainForm_Load);
			((System.ComponentModel.ISupportInitialize)(this.axKnTView2)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// AvP[ṼC Gg |CgłB
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private void MainForm_Load(object sender, System.EventArgs e)
		{
			LoadSchedule();

			axKnTView2.ViewTopTime = "1999/8/5 8:00";
    
			KnTViewLib.TimeScale tscale;
			KnTViewLib.LetterScale scaleL;
			KnTViewLib.LetterScale scaleM;
			KnTViewLib.LineScale scaleS;
    
			tscale = axKnTView2.TimeScale;
			scaleL = axKnTView2.TimeScale.Large;
			scaleM = axKnTView2.TimeScale.Medium;
			scaleS = axKnTView2.TimeScale.Small;

			tscale.WidthPerScale = (float)30;
			scaleL.Format = "yyyyNmd(aaa)";
			scaleM.Format = "h";
			scaleS.Height = (float)6;
			scaleS.SubInterval = 30;
			
			//axKnTView2.ColumnHeaders.Add(null,null);
			KnTViewLib.IColumnHeader ch;
			ch = axKnTView2.ColumnHeaders.Item(1);
			ch.Text = "";
			ch.Width = (float)50;
			
			ch = axKnTView2.ColumnHeaders.Item(2);
			ch.Text = "ؿ";
			ch.Width = (float)50;

			KnTViewLib.SpecialTimeSet sptset;
			KnTViewLib.SpecialTime sptime;

			sptset = axKnTView2.SpecialTimeSets.Add(null, null);
			sptime = sptset.SpecialTimes.Add(null, null);

			sptime.Start = "12:00";
			sptime.Finish = "13:00";
			sptime.Fill.BkMode = KnTViewLib.TivBkMode.tivTransparent;
			sptime.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternForwardDiagonal;

			KnTViewLib.PiecePane pcepane;
			pcepane = axKnTView2.PiecePane;
			pcepane.SpecialTimeSet = sptset;

			KnTViewLib.Item itm;
			KnTViewLib.Piece pce;
			KnTViewLib.PieceCaption pcap;
			KnTViewLib.Progress prgrs;
			
			string str;
			char chr;
			for ( int i = 1 ; i < 20 ; i++ )
			{
				chr = Convert.ToChar(64 + i);
				str = chr.ToString();
				itm = axKnTView2.Items.Add(null, null);
				itm.Cells.Item(1).Value = " " + str;
				itm.Cells.Item(2).Value = "ؿ " + Convert.ToString(i);
			}

			for (int j = 0 ; j < Schedules.Length - 1 ; j++ )
			{
				itm = axKnTView2.Items.Item(Schedules[j+1].TaskIndex);
		        
				pce = itm.Pieces.Add(null, null);
				pce.Start = Schedules[j+1].Start;
				pce.Finish = Schedules[j+1].Finish;
		        
				prgrs = pce.Progresses.Add(null, null);
				prgrs.PercentTo = Schedules[j+1].Progress;
		        
				pcap = pce.Captions.Add(null, null);
				pcap.Position = KnTViewLib.TivPieceCaptionPosition.tivPieceRight;
				pcap.Type = KnTViewLib.TivPieceCaptionType.tivPieceCaptionProgress1To;
			}
		}

		private void axKnTView2_AfterPieceAdd(object sender, AxKnTViewLib._DKnTViewEvents_AfterPieceAddEvent e)
		{
			e.cancel.Value = true;
			
			KnTViewLib.Piece pce;
			pce = e.item.Pieces.Add(null, null);
			pce.Start = e.start;
			pce.Finish = e.finish;
			
			KnTViewLib.Progress prgrs;
			prgrs = pce.Progresses.Add(null, null);
			prgrs.PercentTo = 0.3;
    
			KnTViewLib.PieceCaption pcap;
			pcap = pce.Captions.Add(null, null);
			pcap.Position = KnTViewLib.TivPieceCaptionPosition.tivPieceRight;
			pcap.Type = KnTViewLib.TivPieceCaptionType.tivPieceCaptionProgress1To;
		}

		private void cmdPreview_Click(object sender, System.EventArgs e)
		{
			KnTViewLib.IPrintInfo pi = new KnTViewLib.PrintInfo();
			pi.PaperSize = KnTViewLib.TivPaperSize.tivPaperA4;
			axKnTView2.PrintPreview((KnTViewLib.PrintInfo)pi);
		}

		private void cmdCoolNo1_Click(object sender, System.EventArgs e)
		{
			KnTViewLib.TimeScale tscale;
			KnTViewLib.LetterScale scaleL;
			KnTViewLib.LetterScale scaleM;
			KnTViewLib.LineScale scaleS;
			KnTViewLib.PiecePane pcepane;
		    
			tscale = axKnTView2.TimeScale;
			scaleL = axKnTView2.TimeScale.Large;
			scaleM = axKnTView2.TimeScale.Medium;
			scaleS = axKnTView2.TimeScale.Small;
			pcepane = axKnTView2.PiecePane;

			scaleL.Fill.BackColor = RGB(0, 0, 0);
			scaleL.Color = RGB(156, 206, 255);
			scaleM.Fill.BackColor = RGB(0, 0, 0);
			scaleM.Color = RGB(0, 206, 255);
			scaleS.Fill.BackColor = RGB(0, 0, 0);
			scaleS.Line.Color = RGB(49, 49, 156);
			scaleS.SubLine.Color = RGB(49, 49, 156);
			tscale.BottomBorder.Color = RGB(49, 49, 156);

			pcepane.MediumLine.Style = KnTViewLib.TivLineStyle.tivLineSolid;
			pcepane.MediumLine.Color = RGB(49, 49, 156);
			pcepane.SpecialTimeSet.SpecialTimes.Item(1).Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternForwardDiagonal;
			pcepane.SpecialTimeSet.SpecialTimes.Item(1).Fill.ForeColor = RGB(32, 32, 32);

			foreach (KnTViewLib.ColumnHeader ch in axKnTView2.ColumnHeaders)
			{
				ch.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternNull;
				ch.Fill.BackColor = RGB(0, 0, 0);
				ch.Color = RGB(255, 255, 255);
				ch.BottomBorder.Color = RGB(49, 49, 156);
				ch.RightBorder.Style = KnTViewLib.TivLineStyle.tivLineNull;
			}
		    
			foreach (KnTViewLib.Item itm in axKnTView2.Items)
			{
				if (itm.Index % 5 == 0)
					itm.PiecePane.Fill.BackColor = RGB(0, 0, 64);
				else
					itm.PiecePane.Fill.BackColor = RGB(0, 0, 0);
				
				itm.PiecePane.BottomBorder.Color = RGB(49, 49, 156);

				foreach (KnTViewLib.Cell cel in itm.Cells)
				{
					if ((itm.Index == 3) & (cel.Index == 1))
					{
						cel.Fill.BackColor = RGB(0, 44, 87);
						cel.Fill.ForeColor = RGB(0, 0, 0);
						cel.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternHorizontalGradation;
					}
					else if ((itm.Index == 6) & (cel.Index == 2))
					{
						cel.Fill.BackColor = RGB(0, 44, 87);
						cel.Fill.ForeColor = RGB(0, 0, 0);
						cel.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternHorizontalGradation;
					}
					else
					{
						cel.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternNull;
						cel.Fill.BackColor = RGB(0, 0, 0);
					}
					cel.Color = RGB(255, 255, 255);
					cel.BottomBorder.Color = RGB(49, 49, 156);
					cel.RightBorder.Style = KnTViewLib.TivLineStyle.tivLineNull;
				}

				foreach (KnTViewLib.Piece pce in itm.Pieces)
				{
					pce.BarShape.Shape = KnTViewLib.TivBarShape.tivBarShapeRectangle;
					pce.BarShape.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternFineForwardDiagonal;
					pce.BarShape.Fill.BackColor = RGB(0, 0, 255);
					pce.BarShape.Fill.ForeColor = RGB(49, 99, 255);
					pce.BarShape.Line.Color = RGB(24, 57, 156);
					pce.StartShape.Shape = KnTViewLib.TivPointShape.tivPointShapeNull;
					pce.FinishShape.Shape = KnTViewLib.TivPointShape.tivPointShapeNull;
					foreach (KnTViewLib.PieceCaption pcap in pce.Captions)
						 pcap.Color = RGB(206, 206, 206);
					pce.Progresses.Item(1).Shape = KnTViewLib.TivBarShape.tivBarShapeCenterRectangle;
					pce.Progresses.Item(1).Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternHorizontalGradation;
					pce.Progresses.Item(1).Fill.BackColor = RGB(0, 126, 255);
					pce.Progresses.Item(1).Fill.ForeColor = RGB(156, 206, 255);
					pce.Progresses.Item(1).Line.Style = KnTViewLib.TivLineStyle.tivLineSolid;
					pce.Progresses.Item(1).Line.Color = RGB(24, 57, 156);
				}
			}
		}
		
		private uint RGB( int red, int green, int blue ) 
		{
			return (uint)(blue << 16 | green << 8 | red);
		}

		private void cmdCoolNo2_Click(object sender, System.EventArgs e)
		{
			KnTViewLib.TimeScale tscale;
			KnTViewLib.LetterScale scaleL;
			KnTViewLib.LetterScale scaleM;
			KnTViewLib.LineScale scaleS;
			KnTViewLib.PiecePane pcepane;
		    
			tscale = axKnTView2.TimeScale;
			scaleL = axKnTView2.TimeScale.Large;
			scaleM = axKnTView2.TimeScale.Medium;
			scaleS = axKnTView2.TimeScale.Small;
			pcepane = axKnTView2.PiecePane;

			scaleL.Fill.BackColor = RGB(222, 199, 161);
			scaleL.Color = RGB(0, 0, 0);
			scaleM.Fill.BackColor = RGB(222, 199, 161);
			scaleM.Color = RGB(0, 0, 0);
			scaleS.Fill.BackColor = RGB(222, 199, 161);
			scaleS.Line.Color = RGB(0, 0, 0);
			scaleS.SubLine.Color = RGB(0, 0, 0);
			tscale.BottomBorder.Color = RGB(0, 0, 0);

			pcepane.MediumLine.Style = KnTViewLib.TivLineStyle.tivLineNull;
			pcepane.SpecialTimeSet.SpecialTimes.Item(1).Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternDiagonalCross;
			pcepane.SpecialTimeSet.SpecialTimes.Item(1).Fill.ForeColor = RGB(167, 199, 220);
			
			foreach (KnTViewLib.ColumnHeader ch in axKnTView2.ColumnHeaders)
			{
				ch.Fill.Pattern = KnTViewLib.TivFillPattern.tivPattern3D;
				ch.Fill.BackColor = RGB(222, 199, 161);
				ch.Color = RGB(0, 0, 0);
				ch.BottomBorder.Color = RGB(0, 0, 0);
				ch.RightBorder.Style = KnTViewLib.TivLineStyle.tivLineNull;
			}
			
			foreach (KnTViewLib.Item itm in axKnTView2.Items)
			{
				if (itm.Index % 5 == 0)
					itm.PiecePane.Fill.BackColor = RGB(203, 207, 222);
				else
					itm.PiecePane.Fill.BackColor = RGB(224, 226, 231);
				
				itm.PiecePane.BottomBorder.Color = RGB(127, 127, 127);

				foreach (KnTViewLib.Cell cel in itm.Cells)
				{
					cel.Fill.Pattern = KnTViewLib.TivFillPattern.tivPattern3D;
					if ((itm.Index == 3) & (cel.Index == 1))
					{
						cel.Fill.BackColor = RGB(123, 148, 173);
						cel.Color = RGB(0, 0, 64);
					}
					else if ((itm.Index == 6) & (cel.Index == 2))
					{
						cel.Fill.BackColor = RGB(123, 148, 173);
						cel.Color = RGB(0, 0, 64);
					}
					else
					{
						cel.Fill.BackColor = RGB(235, 206, 202);
						cel.Color = RGB(64, 0, 0);
					}
					cel.RightBorder.Color = RGB(127, 127, 127);
					cel.RightBorder.Style = KnTViewLib.TivLineStyle.tivLineSolid;
					cel.BottomBorder.Color = RGB(127, 127, 127);
					cel.BottomBorder.Style = KnTViewLib.TivLineStyle.tivLineSolid;
				}

				foreach (KnTViewLib.Piece pce in itm.Pieces)
				{
					pce.BarShape.Shape = KnTViewLib.TivBarShape.tivBarShapeLine;
					pce.BarShape.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternVerticalGradation;
					pce.BarShape.Fill.BackColor = RGB(255, 0, 0);
					pce.BarShape.Fill.ForeColor = RGB(0, 0, 255);
					pce.BarShape.Line.Color = RGB(128, 0, 64);
					pce.StartShape.Shape = KnTViewLib.TivPointShape.tivPointShapeCircle;
					pce.StartShape.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternVerticalGradation;
					pce.StartShape.Fill.BackColor = RGB(0, 0, 255);
					pce.StartShape.Fill.ForeColor = RGB(0, 198, 255);
					pce.StartShape.Line.Color = RGB(0, 198, 255);
					pce.FinishShape.Shape = KnTViewLib.TivPointShape.tivPointShapeStar;
					pce.FinishShape.Fill.Pattern = KnTViewLib.TivFillPattern.tivPatternVerticalGradation;
					pce.FinishShape.Fill.BackColor = RGB(255, 0, 0);
					pce.FinishShape.Fill.ForeColor = RGB(255, 198, 0);
					pce.FinishShape.Line.Style = KnTViewLib.TivLineStyle.tivLineNull;
					foreach (KnTViewLib.PieceCaption pcap in pce.Captions)
						pcap.Color = RGB(63, 63, 63);
					pce.Progresses.Item(1).Shape = KnTViewLib.TivBarShape.tivBarShapeLowerLine;
					pce.Progresses.Item(1).Fill.Pattern = KnTViewLib.TivFillPattern.tivPattern3D;
					pce.Progresses.Item(1).Fill.BackColor = RGB(255, 128, 192);
				}
			}
		}

		private void cmdSecondForm_Click(object sender, System.EventArgs e)
		{
			SecondForm frm;
			frm = new SecondForm();

			frm.Show();
		}
	}
}
